import { NextResponse } from 'next/server';
import dbConnect from '@/lib/db';
import Leader from '@/models/Leader';

export async function PUT(req: Request, props: { params: Promise<{ id: string }> }) {
  const params = await props.params;
  await dbConnect();
  try {
    const body = await req.json();
    const leader = await (Leader as any).findByIdAndUpdate(params.id, body, { new: true });
    if (!leader) return NextResponse.json({ error: 'Leader not found' }, { status: 404 });
    return NextResponse.json(leader);
  } catch (error) {
    return NextResponse.json({ error: 'Failed to update leader' }, { status: 500 });
  }
}

export async function DELETE(req: Request, props: { params: Promise<{ id: string }> }) {
  const params = await props.params;
  await dbConnect();
  try {
    const leader = await (Leader as any).findByIdAndDelete(params.id);
    if (!leader) return NextResponse.json({ error: 'Leader not found' }, { status: 404 });
    return NextResponse.json({ message: 'Leader deleted' });
  } catch (error) {
    return NextResponse.json({ error: 'Failed to delete leader' }, { status: 500 });
  }
}